// dos2be v1.1 //
// Coded by Ian Seyler (seyleri@hotmail.com) on 8/19/1999 //
// Purpose : Removes carriage returns (0x0D) from DOS\Windows text files //
// Changes in v1.1 : Shortened and cleaned up some of the code.

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char *argv[])
{
	FILE *InputFile;
	FILE *OutputFile;
	char InputFileName[41];
	char OutputFileName[43];
	char *OutputEnd = "~1";
	char CurrentChar[2];
	char Flag='0';

	// display program info if no arguments were given.
	if(argc == 1)
	{
		printf("dos2be v1.1 by Ian Seyler on 8/19/1999\n");
		printf("Usage : dos2be inputfile outputfile(optional)\n");
		exit(EXIT_FAILURE);
	}

	// setup file names from the given arguments
	// also setup an output filename if none was given
	strcpy(InputFileName, argv[1]);
	if(argv[2] == NULL)
	{
		strcpy(OutputFileName, InputFileName);
		strcat(OutputFileName, OutputEnd);
		Flag='1';
	}
	else
	{
		strcpy(OutputFileName, argv[2]);
		// in case the input and output names are the same
		if(strcmp(InputFileName, OutputFileName) == 0)
		{
			strcat(OutputFileName, OutputEnd);
			Flag='1';
		}
	}	

	// open the input and output files
	if((InputFile=fopen(InputFileName,"rb"))==NULL)
	{
		printf("dos2be : Error opening the input file \"%s\"\n",InputFileName);
		exit(EXIT_FAILURE);
	}
	OutputFile=fopen(OutputFileName,"wb");

	// print different information depending on method
	if (Flag=='0')
		printf("Converting \"%s\" to \"%s\" in the BeOS text format...\n", InputFileName, OutputFileName);
	else
		printf("Converting \"%s\" into the BeOS text format...\n", InputFileName);
		
	// the main conversion loop, read character
	while (fread(CurrentChar, 1, 1, InputFile) == 1)
		// check if its a carriage return character
		if(CurrentChar[0] != 13) // the decimal value of 0x0D
			// if not then write it into the output file
			fwrite(CurrentChar, 1, 1, OutputFile);

	// if no output file was given then delete the input file and rename the output file
	if (Flag!='0')
	{
		remove (InputFileName);
		rename (OutputFileName, InputFileName);
	}
	
	// all done, exit command will close the files
	exit(EXIT_SUCCESS);	
}